
/**************************************************************************
**                                                                        *
**  FILE        :  wcsxrfm.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcsxfrm routine.                       *
**                 Transforms s2 and places result into s1.               *
**                 Returns the length of transformed wide string.         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

size_t
wcsxfrm( wchar_t* restrict s1, const wchar_t* restrict s2, size_t n )
{
        size_t len_s2;

        len_s2 = wcslen( s2 );

        if ( len_s2 < n )
        {
                wcscpy( s1, s2 );
        }

        return len_s2;
}

#endif
