
/**************************************************************************
**                                                                        *
**  FILE        :  wcstod.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wcstod routine.                        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include <math.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wchar.h>

#ifndef DBL_MAX_10_MANT
/* #define DBL_MAX_10_MANT (DBL_MAX)/pow(10,DBL_MAX_10_EXP) */
#if (DBL_MAX_10_EXP) == 38
#define DBL_MAX_10_MANT 3.402823466385          /* (pow(2,128)-pow(2,104))/pow(10,38) */
#elif (DBL_MAX_10_EXP) == 308
#define DBL_MAX_10_MANT 1.7976931348623157      /* (pow(2,1024)-pow(2,971))/pow(10,308) */
#endif
#endif
#ifndef DBL_MIN_10_MANT
/* #define DBL_MIN_10_MANT (DBL_MIN)/(pow(10,DBL_MIN_10_EXP)-1) */
#if (DBL_MIN_10_EXP) == -37
#define DBL_MIN_10_MANT 1.175494350822          /* pow(2,-126)/pow(10,-38) */
#elif (DBL_MIN_10_EXP) == -307
#define DBL_MIN_10_MANT 2.2250738585072014      /* pow(2,-1022)/pow(10,-308) */
#endif
#endif

extern long double _wcstod( const wchar_t * restrict p, wchar_t ** restrict ptr,
                            int min_exponent, int max_exponent, long double min_mantissa,
                            long double max_mantissa, long double huge_value );

double
wcstod( const wchar_t* restrict nptr, wchar_t** restrict endptr)
{
        return (double) _wcstod( nptr, endptr, DBL_MIN_10_EXP, DBL_MAX_10_EXP,
                                 DBL_MIN_10_MANT, DBL_MAX_10_MANT, HUGE_VAL);
}

#endif
