
/**************************************************************************
**                                                                        *
**  FILE        :  wcsstr.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wcsstr routine.                        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Locate the first occurence in the wide string pointed to by s1 of the
 * sequence of wide characters (excluding the terminating null wide
 * character) in the wide string pointed to by s2.
 *
 * Return a pointer to the located wide string if found; otherwise return a
 * null pointer. Return s1, if s2 points to a wide string with zero length.
 */
wchar_t*
wcsstr( const wchar_t*s1, const wchar_t*s2 )
{
        wchar_t* p;

        if ( s1 && s2 )
        {
                /* Check for the terminating null wide character.
                 */
                if ( *s2 == (wchar_t) 0 )
                {
                        return (wchar_t *) s1;
                }

                for ( ; *s1; s1++ )
                {
                        if ( *s1 == *s2 )
                        {
                                p = (wchar_t *) s1;

                                for ( ; *s2 && *s1; s2++, s1++ )
                                {
                                        if ( *s1 != *s2 )
                                        {
                                                return NULL;
                                        }
                                }

                                return p;
                        }
                }
        }

        return NULL;
}

#endif
