
/**************************************************************************
**                                                                        *
**  FILE        :  wcsncmp.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcsncmp routine.                       *
**                 Compares s1 and s2, but not more than n wide           *
**                 characters.                                            *
**                 Returns < 0 if s1 <  s2                                *
**                           0 if s1 == s2                                *
**                         > 0 if s1 >  s2                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

int wcsncmp(const wchar_t *s1, const wchar_t *s2, size_t n)
{
        while( n-- )
        {
                if( *s1 != *s2 )
                        return(*s1 - *s2);

                if ( !*s1 )
                        break;
                s2++;
                s1++;
        }
        return 0;
}

#endif
