
/**************************************************************************
**                                                                        *
**  FILE        :  wcsncat.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcsncat routine.                       *
**                 Appends not more than n wide characters of s2 at the   *
**                 end of s1.                                             *
**                 Returns s1.                                            *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

wchar_t *wcsncat(wchar_t * restrict s1, const wchar_t * restrict s2, size_t n)
{
        wchar_t *new_s1 = s1;

        if (s1 && s2)
        {
                while (*s1)
                {
                        s1++;
                }

                for (; *s2 && n > 0; s1++, s2++, n--)
                {
                        *s1 = *s2;
                }

                /* Append the terminating null wide character.
                 */
                *s1 = (wchar_t) 0;
        }

        return new_s1;
}

#endif
