
/**************************************************************************
**                                                                        *
**  FILE        :  wcslen.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wcslen routine.                        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Compute the length of the wide string pointed to by s.
 *
 * Return the number of wide characters that precede the terminating null 
 * wide character.
 */
size_t wcslen(const wchar_t *s)
{
        size_t len = 0;

        if (s)
        {
                while (*s)
                {
                        s++;
                        len++;
                }
        }

        return len;
}

#endif
