
/**************************************************************************
**                                                                        *
**  FILE        :  wcscoll.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcscoll routine.                       *
**                 Compares s1 and s2, both interpreted as appropriate to *
**                 the current LC_COLLATE category of the current locale. *
**                 Returns < 0 if s1 <  s2                                *
**                           0 if s1 == s2                                *
**                         > 0 if s1 >  s2                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

int wcscoll(const wchar_t *s1, const wchar_t *s2)
{
        return wcscmp(s1, s2);
}

#endif
