
/**************************************************************************
**                                                                        *
**  FILE        :  wcrtomb.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcrtomb routine.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdlib.h>
#include <errno.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wchar.h>

/*
 * Determines the number of bytes needed to represent the multibyte 
 * character that corresponds to the wide character given by wc (including 
 * any shift sequences), and stores the resulting bytes in the array whose 
 * first element is pointed to by s. At most MB_CUR_MAX bytes are stored.
 *
 * Return (size_t) -1 if wc is not a valid wide character; otherwise
 * return the number of bytes stored in the buffer.
 */
size_t wcrtomb(char * restrict s, wchar_t wc, mbstate_t * restrict ps)
{
        static  mbstate_t       internal_state  = {0};
        char                    internal_buf[MB_CUR_MAX];
        char *                  ptbuf;
        size_t                  n_bytes;
        mbstate_t *             ptstate;

        if (ps == NULL)
        {
                ptstate = &internal_state;
        }
        else
        {
                ptstate = ps;
        }

        if (s == NULL)
        {
                ptbuf = internal_buf;
                wc = (wchar_t) 0;
        }
        else
        {
                ptbuf = s;
        }

#if 1
        /* Minimal implementation, multibyte consists of one byte. */
        if ( (wc < 0)
#if UINT_MAX > UCHAR_MAX             
             || (wc > (wchar_t) UCHAR_MAX)
#endif
             )
        {
                /* This wide character hasn't a corresponding multibyte character.
                 */
                errno = EILSEQ;
                n_bytes = (size_t) -1;
                INIT_MBSTATE_OBJECT(internal_state);
        }
        else
        {
                ptbuf[0] = (char) wc;
                n_bytes = 1;
                INIT_MBSTATE_OBJECT(*ptstate);
        }
#else
        for (n_bytes = 0; n_bytes < MB_CUR_MAX; n_bytes++)
        {
                if (ptstate->encoding == 0)
                {
                        /* The multibyte consists of one byte.
                         */
                        if ( (wc < 0) || (wc > (wchar_t) UCHAR_MAX) )
                        {
                                /* This wide character hasn't a corresponding multibyte character.
                                 */
                                errno = EILSEQ;
                                n_bytes = (size_t) -1;
                                INIT_MBSTATE_OBJECT(internal_state);
                                        }
                        else
                        {
                                ptbuf[0] = (char) wc;
                                n_bytes = 1;
                                INIT_MBSTATE_OBJECT(*ptstate);
                                        }
                        break;
                }
                else
                {
                        /* The multibyte consists of more than one byte.
                         */

                        /* Store the corresponding multibyte of the wide character
                         * wc in ptbuf using ptstate->encoding.
                         */
                }
        }
#endif
        return n_bytes;
}

#endif
