
/**************************************************************************
**                                                                        *
**  FILE        :  vwprintf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for vwprintf() routine.                    *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int vwscanf( const wchar_t * restrict format, va_list arg )
{
        int             items;
        struct _io      io;

        io.fp = stdin;
        items = _dowscan( &io, format, arg );
        return (ferror(stdin) ? EOF : items);
}

#endif
