
/**************************************************************************
**                                                                        *
**  FILE        :  vswprintf.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for vswprintf routine.                     *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Return number of wide characters written or a negative number if
 * n or more wide characters were requested to be generated.
 */
int vswprintf(wchar_t * restrict s, size_t n, const wchar_t * restrict format,
              va_list arg)
{
        int             chars;
        struct _io      buf;

        chars = -1;
        if (n)
        {
                buf.fp = NULL;
                buf.ptr = (char *) s;
                buf.end = (char *)(s + n);
                chars = _dowprint( & buf, format, arg );
                s = (wchar_t *)buf.ptr;
                if ( chars >= n )
                {
                        --s;
                        chars = -1;
                }
                *s = L'\0';
        }
        return chars;
}

#endif
