
/**************************************************************************
**                                                                        *
**  FILE        :  vfwprintf.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for vfwprintf routine.                     *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Return number of wide characters written or a negative number if
 * an output failure occured.
 */
int vfwprintf(FILE * restrict stream, const wchar_t * restrict format, va_list arg)
{
        int n_chars = _dowprint((struct _io *)&stream, format, arg);

        return (ferror(stream) ? EOF : n_chars);
}

#endif
