

;;; Template code for linker-generated interworking and long branch veneers.
        
.IF @CPU('ARMv7M')
        
;;; ARMv7M only requires a single long veneer template. The long veneer is Thumb2 code.
;;; The veneer can be used as a long branch veneer when an out-of-range Thumb function
;;; is called from Thumb code. This veneer must be Thumb2 code because ARMv7M does not
;;; support ARM code. The veneer can also be used with other T2 architectures and also
;;; to switch from Thumb2 state to ARM state. The long veneer template for ARMv6T2 and
;;; ARMv7 ARM code veneers is identical to the ARMv5 veneer template. As for ARM code,
;;; 32-bit Thumb-2 code veneering is supported for all branch instructions
        
        .extern _lc_t2_longveneertarget
                                        
        .section        .text.t2_longveneertemplate
        .global         .text.t2_longveneertemplate
        .align 4
        .thumb
.text.t2_longveneertemplate:    .type func
        ldr     pc,[pc]                                 ; Load address from .dw and jump, switch to
        .dw     _lc_t2_longveneertarget                 ; ARM state if the symbol has an even value.
        .endsec

.ELSE
        
;;; ARMv4 requires four long veneer templates. One to switch from ARM to Thumb,
;;; one to switch from Thumb to ARM, one for long branches from ARM to ARM and
;;; one for long branches from Thumb to Thumb. For 16-bit Thumb code veneering
;;; is supported for BL and BLX instructions only, not for B and B<cond>.
        
        .extern _lc_v4_AA_longveneertarget
        .extern _lc_v4_AT_longveneertarget
        .extern _lc_v4_TA_longveneertarget
        .extern _lc_v4_TT_longveneertarget
        .extern _lc_v5_longveneertarget
                                        
        .section        .text.v4_AA_longveneertemplate
        .global         .text.v4_AA_longveneertemplate
        .align 4
        .code32
.text.v4_AA_longveneertemplate: .type func
        ldr     pc,[pc,#-4]                             ; Load address from .dw and jump.
        .dw     _lc_v4_AA_longveneertarget              ; This symbol has an even value.
        .endsec

        .section        .text.v4_AT_longveneertemplate
        .global         .text.v4_AT_longveneertemplate
        .align 4
        .code32
.text.v4_AT_longveneertemplate: .type func
        ldr     ip,[pc]                                 ; Load address from .dw into ip.
        bx      ip                                      ; Jump to address and switch to Thumb state.
        .dw     _lc_v4_AT_longveneertarget              ; This symbol has an odd value.
        .endsec

        .section        .text.v4_TA_longveneertemplate
        .global         .text.v4_TA_longveneertemplate
        .align 4
        .code16
.text.v4_TA_longveneertemplate: .type func
        bx      pc                                      ; Switch to ARM state inside veneer!
        nop                                             ; This line will be skipped!
        .code32
        ldr     pc,[pc,#-4]                             ; ARM instruction! Load address and jump.
        .dw     _lc_v4_TA_longveneertarget              ; This symbol has an even value.
        .endsec
 
        .section        .text.v4_TT_longveneertemplate
        .global         .text.v4_TT_longveneertemplate
        .align 4
        .code16
.text.v4_TT_longveneertemplate: .type func
        bx      pc                                      ; Switch to ARM state inside veneer!
        nop                                             ; This line will be skipped!
        .code32
        ldr     ip,[pc]                                 ; ARM instruction! Load address into ip.
        bx      ip                                      ; Jump to address and switch back to Thumb state!
        .dw     _lc_v4_TT_longveneertarget              ; This symbol has an odd value.
        .endsec

;;; ARMv5 and ARMv6 only require a single long veneer template. The long veneer is ARM code.
;;; If the veneer is called from Thumb code, a BLX(1) instruction is used to switch states.
;;; The veneer code is the same as for the v4_AA_longveneer, but the ARMv5 LDR instruction
;;; can switch to Thumb state while the ARMv4 LDR instruction can not. For 16-bit Thumb
;;; code veneering is supported for BL and BLX instructions only, not for B and B<cond>.
;;; This generic veneer also applies to ARMv6T2 and ARMv7 AA and AT veneers.
        
        .section        .text.v5_longveneertemplate
        .global         .text.v5_longveneertemplate
        .align 4
        .code32
.text.v5_longveneertemplate:    .type func
        ldr     pc,[pc,#-4]                             ; Load address from .dw and jump, switch to
        .dw     _lc_v5_longveneertarget                 ; Thumb state if the symbol has an odd value.
        .endsec

.ENDIF  
