
/**************************************************************************
**                                                                        *
**  FILE        :  ungetwc.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for ungetwc routine.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED    

wint_t ungetwc(wint_t c, FILE *stream)
{
        if ((c == WEOF) || !(stream->_flag & _IORD))
        {
                c = WEOF;
        }
        else
        {
                stream->_flag &= ~_IOEOF;

                if (stream->_flag & _IONBF)
                {
                /* Unbuffered I/O.
                 */
                        /* (mis)use _bufsiz to save char.
                         */
                        if (stream->_bufsiz == EOF)
                        {
                                return WEOF;    /* cannot do another ungetwc() */
                        }

                        stream->_bufsiz = (c & 0xff);
                }

                if (stream->_cnt >= 0)
                {
                /* Buffered I/O.
                 */
                        _fflush(stream);        /* make sure that output is flushed */
                        stream->_ptr = stream->_base + stream->_bufsiz;
                        stream->_cnt = -1;      /* setup an empty input buffer */
                }

                stream->_cnt--;         /* reclaim previous buffer position */
                *--stream->_ptr = (char) c;
        }
        return c;
}

#endif
