
/**************************************************************************
**                                                                        *
**  FILE        :  ungetc.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for _ungetc() routine                      *
**                 pushes one character back onto an input stream.        *
**                 returns EOF when unget is not possible                 *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

int     ungetc(int c, FILE *fp)
{
        if (c == EOF || !(fp->_flag & _IORD))
        {
                return EOF;
        }
        if (fp->_flag & _IONBF)         /* deal with ungetc buffer hack */
        {
                if (fp->_bufsiz != EOF)
                {
                        return EOF;
                }
                fp->_bufsiz = (unsigned char)c;
        }
        else                            /* buffered- or string input */
        {
                if (fp->_cnt >= 0)
                {
                        /*
                         * flush output, setup an exhausted input buffer.
                         */
                        _fflush(fp);
                        fp->_ptr += fp->_bufsiz;
                        fp->_cnt = -1;
                }
                if (fp->_ptr == fp->_base)
                {
                        return EOF;
                }
                fp->_cnt--;             /* reclaim previous buffer position */
                *--fp->_ptr = (char)c;
        }
        fp->_flag &= ~_IOEOF;
        return c;
}
