
/**************************************************************************
**                                                                        *
**  FILE        :  tan.c                                                  *
**                                                                        *
**  DESCRIPTION :  Source file for tan() routine                          *
**                 Computes the 'tangent' for the given angle (in radians)*
**                                                                        *
**      Coefficients double are #4285 from Hart & Cheney. (19.74D)        *
**      Coefficients single are #4282 from Hart & Cheney. ( 7.85D)        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>
#include <errno.h>
#include <limits.h>

#if 0


#define INVPI    ( 1.27323954473516268l)      /*   ( 4 / PI )   */
#define P0       (-0.1306820264754825668269611177e+5)
#define P1       ( 0.1055970901714953193602353981e+4)
#define P2       (-0.1550685653483266376941705728e+2)
#define P3       ( 0.3422554387241003435328470489e-1)
#define P4       ( 0.3386638642677172096076369e-4)
#define Q0       (-0.1663895238947119001851464661e+5)
#define Q1       ( 0.4765751362916483698926655581e+4)
#define Q2       (-0.1555033164031709966900124574e+3)
#define POLYNOMIAL(x,arg)       ( ( ( ( ( ( P4 * (arg) + P3 ) * (arg) + P2 ) * (arg) + P1 ) * (arg) + P0 ) * (x) ) / \
                        ( ( ( (arg) + Q2 ) * (arg) + Q1 ) * (arg) + Q0 ) )

static
long double
_tan_qpf( long double arg )
{
        long double     x;
        signed char     sign;
        char            flag;
        int             quad;

        flag = 0;
        sign = 1;
        if( arg < 0.0l )
        {
                arg = -arg;
                sign = -1;
        }
        arg = arg * INVPI;   /* overflow? */
        x = modfl( arg, &arg ); /* From here we don't need the value of 'arg' anymore */
                                /* So we use 'arg' for other purposes */
        if (arg > (long double)INT_MAX)
        {       
                quad = fmodl(arg, 4);
        }
        else
        {
                quad = (int) arg % 4;
        }
        switch( quad )
        {
        case 1:
                x = 1.0l - x;
                flag = 1;
                break;
        case 2:
                sign = -sign;
                flag = 1;
                break;
        case 3:
                x = 1.0l - x;
                sign = -sign;
                break;
        }

        arg = x * x;
        arg = POLYNOMIAL(x,arg);

        if( flag == 1 )
        {
                if( arg == 0.0l )
                {
                        errno = ERANGE;
                        if ( sign > 0 )
                                return( HUGE_VALL );
                        return( -HUGE_VALL );
                }
                arg = 1.0l / arg;
        }

        if( sign == 1 )
                return( arg );
        else
                return( -arg );
}

#endif

