
/**************************************************************************
**                                                                        *
**  FILE        :  swprintf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for swprintf() routine.                    *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int swprintf( wchar_t * restrict s, size_t n, const wchar_t * restrict format, ... )
{
        va_list         ap;
        int             chars;
        struct _io      buf;

        va_start( ap, format );
        buf.fp = NULL;
        buf.ptr = (char *) s;
        buf.end = (char *)( s ? s + n - 1 : NULL );
        chars = _dowprint( & buf, format, ap );
        va_end( ap );
        s = (wchar_t *)buf.ptr;
        if ( chars >= n )
        {
                if (s) --s;
                chars = -1;
        }
        if (s && n) *s = L'\0';

        return chars;
}

#endif
