
/**************************************************************************
**                                                                        *
**  FILE        :  strncmp.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for strncmp() routine                      *
**                 Compares two strings to eachother.                     *
**                 Returns : < 0  -- s1<s2                                *
**                           = 0  -- s1=s2                                *
**                           > 0  -- s1>s2                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <string.h>


int
strncmp( register const char * s1, register const char * s2, size_t n )
{
        unsigned char c1, c2;
        while ( n )
        {
                n--;
                c2 = *s2++;
                c1 = *s1++;
                if ( c1 == '\0' || c1 != c2 )
                        return( (int)c1 - (int)c2 );
        }
        return 0;
}
