
/**************************************************************************
**                                                                        *
**  FILE        :  strchr.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for strchr() routine                       *
**                 Search for the first occurrence of a character         *
**                 in a string.                                           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <string.h>

char *
strchr( register const char *cs, int c )
{
        unsigned char   x;

        do
        {
                x = *cs++;
                if      ( x == (unsigned char) c ) /* found character ? */
                {
                        return (char *) cs - 1;
                }
        } while ( x );
        return NULL;                    /* character not found          */
}
