
/**************************************************************************
**                                                                        *
**  FILE        :  sqrt.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for sqrt() routine                         *
**                 Computes the 'square' root for the given value         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**  Based on Cephes Math Library Release 2.2:  June, 1992 ( Copyright     *
**  1984, 1987, 1988, 1992 by Stephen L. Moshier )                        *
**                                                                        *
**************************************************************************/

#include <math.h>
#include <errno.h>
#include <stdlib.h>
#include <float.h>
#include "fpbits.h"

#ifdef __SINGLE_FP__
#pragma alias   sqrtl   = _sqrt_spf
#pragma alias   sqrt    = _sqrt_spf
#endif
#pragma alias   sqrtf   = _sqrt_spf

#ifndef SQRT2
/* sqrt(2) */
#define SQRT2 1.41421356237f
#endif

float
_sqrt_spf( float arg )
{
        int     e;
        float   z, w;

        if ( arg <= 0.0f )
        {
                if ( arg < 0.0f )
                {
                        errno = EDOM;
#if _IEEE_754_FORMAT
                        {
                        float2long_t    u;

                        u.l = 0xffffffff;

                        return u.f;
                        }
#endif
                }
                return( 0.0f );
        }

        /* separate exponent and significand */
        z = frexpf( arg, &e );

        if ( e & 1 )
        {
                z += z;
                e--;
        }

        e /= 2;

        if ( z > SQRT2 )
        {
                /* z is between sqrt(2) and 2. */
                z -= 2.0f;
                w =
                ((((( -9.8843065718E-4f * z
                  + 7.9479950957E-4f) * z
                  - 3.5890535377E-3f) * z
                  + 1.1028809744E-2f) * z
                  - 4.4195203560E-2f) * z
                  + 3.5355338194E-1f) * z
                  + SQRT2;
                goto sqdon;
        }

        if( z > 0.707106781187f )
        {
                /* z is between sqrt(2)/2 and sqrt(2). */
                z -= 1.0f;
                w =
                ((((( 1.35199291026E-2f * z
                  - 2.26657767832E-2f) * z
                  + 2.78720776889E-2f) * z
                  - 3.89582788321E-2f) * z
                  + 6.24811144548E-2f) * z
                  - 1.25001503933E-1f) * z * z
                  + 0.5f * z
                  + 1.0f;
                goto sqdon;
        }

        /* z is between 0.5 and sqrt(2)/2. */
        z -= 0.5f;
        w =
        ((((( -3.9495006054E-1f * z
          + 5.1743034569E-1f) * z
          - 4.3214437330E-1f) * z
          + 3.5310730460E-1f) * z
          - 3.5354581892E-1f) * z
          + 7.0710676017E-1f) * z
          + 7.07106781187E-1f;

sqdon:
        arg = ldexpf( w, e );

        return(arg);

}
