
/**************************************************************************
**                                                                        *
**  FILE        :  snprintf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for snprintf() routine.                    *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <io.h>

int snprintf( char * restrict s, size_t n, const char * restrict format, ... )
{
        va_list         ap;
        int             chars;
        struct _io      buf;

        va_start( ap, format );
        buf.fp = NULL;
        buf.ptr = s;
        buf.end = ( s ? s + n - 1 : NULL );
        chars = _doprint( & buf, format, ap );
        va_end( ap );
        if (s && n) *buf.ptr = 0;

        return chars;
}
