

; __setspsr() for Thumb mode
        
        .section .text.libc

        .global __TASKING_setspsr
        .code16                         ; msr/mrs only availlable in ARM mode
        .align  4

__TASKING_setspsr:      .type func
        bx      pc                      ; jumps to current location + 4 in ARM mode
        nop
        
        .code32
        mrs     r0,spsr
        orr     r0,r0,r1
        bic     r0,r0,r2
        bic     r0,r0,#32               ; Reset Thumb bit, because msr executes in ARM mode
        msr     spsr_fsxc,r0
        bx      lr
        .size   __TASKING_setspsr,$-__TASKING_setspsr

        .endsec

        .calls  '__TASKING_setspsr','',0

        .end
