
/**************************************************************************
**                                                                        *
**  FILE        :  setbuf.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for setbuf() routine                       *
**                 Adds a buffer to the given stream                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>

/*
 * To prevent linking in malloc/free and the allocation of the heap
 * when setbuf is called, _dofree is called instead of free.
 * _dofree is a weak definition that defaults to an alias for _weakstub,
 * but it is overruled by an alias for free when malloc/free are used.
 */
extern  void    _dofree    ( void * );
#pragma weak    _dofree
#pragma extern  _weakstub

/*
 * Identical to setvbuf(fp, buf, buf ? _IOFBF : _IONBF, BUFSIZ);
 * except that setvbuf():
 * -    drags in malloc() and family.
 * -    has error checking/can return an error.
 */
void setbuf(FILE * restrict fp, char * restrict buf)
{
        _iob_flag_t     flag;

        flag = fp->_flag;
        if (flag & _IOMYBUF)
        {
                _dofree(fp->_base);
        }
        flag &= ~(_IOMYBUF | _IOBUF);
        fp->_base = buf;
        fp->_ptr = buf;
        if (buf)
        {
                flag |= _IOFBF;
                fp->_bufsiz = BUFSIZ;
        }
        else
        {
                flag |= _IONBF;
                fp->_bufsiz = EOF;              /* no ungetc() yet */
        }
        fp->_flag = flag;
        /* fp->_cnt is still zero after fopen()/freopen() */
}
