
/**************************************************************************
**                                                                        *
**  FILE        :  scanf.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for scanf() routine.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <io.h>

int scanf( const char * restrict format, ... )
{
        va_list         ap;
        int             items;
        struct _io      io;

        va_start( ap, format );
        io.fp = stdin;
        items = _doscan( &io, format, ap );
        va_end( ap );
        return (ferror( stdin ) ? EOF : items);
}
