

        .section .text.libc

    .if @BIGENDIAN()
        .define hi1     'r0'
        .define lo1     'r1'
        .define hi2     'r2'
        .define lo2     'r3'
    .else
        .define hi1     'r1'
        .define lo1     'r0'
        .define hi2     'r3'
        .define lo2     'r2'
    .endif
        
        ;; The 64 bits multiply is written in ARM mode. Using the Thumb
        ;; MUL/ADD instructions would result in more cycles and more code.
        
        .thumb
        
        .global __aeabi_lmul
__aeabi_lmul:   .type func
        bx      pc              ; jumps to current location + 8
        nop
        
        .arm    
        stmfd   sp!,{r4,r5}
        umull   r4,r5,lo1,lo2
        mla     hi2,lo1,hi2,r5
        mla     hi1,hi1,lo2,hi2
        mov     lo1,r4
        ldmfd   sp!,{r4,r5}     
        bx      lr
        .size   __aeabi_lmul,$-__aeabi_lmul

        .endsec

        .calls  '__aeabi_lmul','',8

        .end
