
/**************************************************************************
**                                                                        *
**  FILE        :  mul64.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for the __aeabi_lmul() routine. Returns    *
**                 the product of multiplicator and multiplicant.         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

unsigned long long __aeabi_lmul(unsigned long long multiplicator, unsigned long long multiplicant)
{
        unsigned long long result = 0;

        while (multiplicator)
        {
                if (multiplicator & 1)
                {
                        result = result + multiplicant;
                }
                multiplicant <<= 1;
                multiplicator >>= 1;
        }

        return result;
}

