
/*
 * FILE         : memset64.c
 *
 * DESCRIPTION  : ARM 64bit aligned memset
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memset8( void *s, size_t n, int v )
{
        size_t                  i;
        unsigned long long*     so;
        size_t                  n2 = (n + sizeof(unsigned long long) - 1) / sizeof(unsigned long long);
        unsigned char           v2 = (unsigned char) v;
        unsigned long           v3 = (((unsigned long)v2)<<8) | v2;
        unsigned long long      v4;

        v3 |= v3<<16;
        v4 = (((unsigned long long)v3)<<32) | v3;
        so = (unsigned long long *)s;
        for (i = 0;  i < n2;  i++)
                *so++ = v4;
}

