
/*
 * FILE         : memset32.c
 *
 * DESCRIPTION  : ARM 32bit aligned memset
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memset4( void *s, size_t n, int v )
{
        size_t          i;
        unsigned long*  so;
        size_t          n2 = (n + sizeof(unsigned long) - 1) / sizeof(unsigned long);
        unsigned char   v2 = (unsigned char) v;
        unsigned long   v3 = (((unsigned long)v2)<<8) | v2;

        v3 |= v3<<16;
        so = (unsigned long *)s;
        for (i = 0;  i < n2;  i++)
                *so++ = v3;
}

