
/*
 * FILE         : memmove8.c
 *
 * DESCRIPTION  : ARM 8bit aligned memmove
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memmove( void *s, const void *ct, size_t n )
{
        char *so = s;

        if( so > (char *)ct )   /* copy from right to left */
        {
                for(    so+=n, ct = (char *)ct + n;
                        n--;
                        ct = (char *)ct - 1, *--so = *(char *)ct
                   )
                        ;
        }
        else            /* copy from left to right */
        {
                for( ; n--; *so++=*(char *)ct, ct = (char *)ct + 1 )
                        ;
        }
}
