
/*
 * FILE         : memmove64.c
 *
 * DESCRIPTION  : ARM 64bit aligned memmove
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memmove8( void *s, const void *ct, size_t n )
{
        long long       *so = s;
        size_t          n2 = (n + sizeof(long long) - 1) / sizeof(long long);

        if( so > (long long *)ct )      /* copy from right to left */
        {
                for(    so+=n2, ct = (long long *)ct + n2;
                        n2--;
                        ct = (long long *)ct - 1, *--so = *(long long *)ct
                   )
                        ;
        }
        else            /* copy from left to right */
        {
                for( ; n2--; *so++=*(long long *)ct, ct = (long long *)ct + 1 )
                        ;
        }
}
