
/*
 * FILE         : memmove32.c
 *
 * DESCRIPTION  : ARM 32bit aligned memmove
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memmove4( void *s, const void *ct, size_t n )
{
        long    *so = s;
        size_t  n2 = (n + sizeof(long) - 1) / sizeof(long);

        if( so > (long *)ct )   /* copy from right to left */
        {
                for(    so+=n2, ct = (long *)ct + n2;
                        n2--;
                        ct = (long *)ct - 1, *--so = *(long *)ct
                   )
                        ;
        }
        else            /* copy from left to right */
        {
                for( ; n2--; *so++=*(long *)ct, ct = (long *)ct + 1 )
                        ;
        }
}
