
/*
 * FILE         : memcpy64.c
 *
 * DESCRIPTION  : ARM 64bit aligned memcpy
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memcpy8( void * restrict s, const void * restrict ct,
        size_t n )
{
        long long       *so = s;
        size_t          n2 = (n + sizeof(long long) - 1) / sizeof(long long);

        for( ; n2--; *so++=*(long long *)ct, ct = (long long *)ct + 1 )
                ;
}
