
/*
 * FILE         : memcpy32.c
 *
 * DESCRIPTION  : ARM 32bit aligned memcpy
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memcpy4( void * restrict s, const void * restrict ct,
        size_t n )
{
        long    *so = s;
        size_t  n2 = (n + sizeof(long) - 1) / sizeof(long);

        for( ; n2--; *so++=*(long *)ct, ct = (long *)ct + 1 )
                ;
}
