
/*
 * FILE         : memclr64.c
 *
 * DESCRIPTION  : ARM 64bit aligned memclr
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memclr8( void *s, size_t n )
{
        size_t          i;
        long long*      so;
        size_t          n2 = (n + sizeof(long long) - 1) / sizeof(long long);

        so = (long long *)s;
        for (i = 0;  i < n2;  i++)
                *so++ = 0;
}

