
/*
 * FILE         : memclr32.c
 *
 * DESCRIPTION  : ARM 32bit aligned memclr
**  Copyright 1996-2009 Altium BV                                         *
 *
 */

typedef __size_t        size_t;

void
__aeabi_memclr4( void *s, size_t n )
{
        size_t  i;
        long*   so;
        size_t  n2 = (n + sizeof(long) - 1) / sizeof(long);

        so = (long *)s;
        for (i = 0;  i < n2;  i++)
                *so++ = 0;
}

