
/**************************************************************************
**                                                                        *
**  FILE        :  mbsrtowc.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for mbsrtowcs routine.                     *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdlib.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wchar.h>

/*
 * Convert a sequence of multibyte characters, beginning in the conversion 
 * state described by the object pointed to by ps, from the array 
 * indirectly pointed to by src into a sequence of corresponding wide 
 * characters. The converted characters are stored into the array pointed 
 * to by dst (including a terminating null character).
 *
 * Return (size_t) -1 if an encoding error occured; otherwise
 * return the number of multibytes converted, not including the terminating
 * null (if any).
 */
size_t mbsrtowcs(wchar_t * restrict dst, const char ** restrict src, size_t len,
                 mbstate_t * restrict ps)
{
        const   char *ptc;
        wchar_t wc = 0;
        size_t result;
        size_t n_mbytes;
        mbstate_t internal_state;
        mbstate_t *ptstate;

        ptstate = &internal_state;
        n_mbytes = 0;

        if (src != NULL && *src != NULL)
        {
                if (ps == NULL)
                {
                        INIT_MBSTATE_OBJECT(*ptstate);
                }
                else
                {
                        *ptstate = *ps;
                }
                for (ptc = *src; n_mbytes < len; n_mbytes++, ptc++)
                {       
                        result = mbrtowc(&wc, ptc, MB_CUR_MAX, ptstate);

                        if (result == (size_t) -1 || result == (size_t) -2)
                        {
                        /* Encoding error occured.
                         */
                                n_mbytes = (size_t) -1;
                                break;
                        }

                        if (dst != NULL)
                        {
                                *dst = wc;
                                dst++;
                        }

                        if (wc == (wchar_t) 0)
                        {
                        /* Reached end of wide character string.
                         */
                                break;
                        }
                }

                if (n_mbytes != (size_t) -1)
                {
                        if (wc == (wchar_t) 0)
                        {
                                *src = NULL;
                        }
                        else
                        {
                                *src = ptc;
                        }

                        if (ps != NULL)
                        {
                                *ps = *ptstate;
                        }
                }
        }

        return n_mbytes;
}

#endif
