
/**************************************************************************
**                                                                        *
**  FILE        :  mbrtowc.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for mbrtowc routine.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <errno.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wchar.h>

/*
 * Determine the corresponding wide character of the given multibyte 
 * stored in s (and possibly partially resolved and stored in ps).
 * 
 * Return 0 if the next n or fewer bytes complete the multibyte character 
 * that corresponds to the null wide character (which value is stored).
 * 
 * Return > 0 if the next n or fewer bytes complete a valid multibyte 
 * character (which is the value stored); the value returned is the number
 * of bytes that complete the multibyte charcter.
 * 
 * Return (size_t) -2 if the next n bytes contribute to an incomplete (but
 * potentially valid) multibyte character, and all n bytes have been 
 * processed (no value is stored).
 * 
 * Return (size_t) -1 if an encoding error occurs, in which case the next 
 * n or fewer bytes do not contribute to a complete and valid multibyte 
 * character (no value is stored); the value of EILSEQ is stored in errno, 
 * and the conversion state is undefined.
 */
size_t mbrtowc(wchar_t * restrict pwc, const char * restrict s, size_t n,
               mbstate_t * restrict ps)
{
        short complete;
        size_t i;
        size_t result;
static  mbstate_t internal_state = {0};
        mbstate_t *ptstate;
        unsigned short old_n_bytes = 0;

        if (s == NULL || (pwc == NULL && *s == '\0' && n == 1))
        {
                INIT_MBSTATE_OBJECT(internal_state);
                result = 0;
        }
        else
        {
                if (ps == NULL)
                {
                        ptstate = &internal_state;
                }
                else
                {
                        ptstate = ps;
                }
                complete = 0;

                for (i = ptstate->n_bytes; i < n; i++)
                {
                        if (ptstate->encoding == 0)
                        {
                        /* The multibyte consists of one byte.
                         */
                                old_n_bytes = 0;
                                ptstate->wc_value = s[0];
                                ptstate->n_bytes = 1;
                                complete = 1;
                                break;
                        }
                        else
                        {
                        /* The multibyte consists of more than one byte.
                         */
                                if (mbsinit(ptstate) == 0)
                                {
                                        old_n_bytes = ptstate->n_bytes;
                        /* There is a partial of the wide character already
                         * solved and stored in ptstate.
                         * ptstate->n_bytes  == number of bytes already been processed
                         * ptstate->wc_value == holds value so far
                         */

                        /* If ptstate->wc_value holds a valid wide character,
                         * then complete = 1; and break;
                         */

                        /* If an encoding error occured, then
                         * i = n-1; and break;
                         */
                                }
                                else
                                {
                        /* If ptstate->wc_value holds a valid wide character,
                         * then complete = 1; and break;
                         */

                        /* If an encoding error occured, then
                         * i = n-1; and break;
                         */
                                }
                        }
                }

                if (complete)
                {
                        if (ptstate->wc_value == (wchar_t) 0)
                        {
                                result = 0;
                        }
                        else
                        {
                                result = ptstate->n_bytes - old_n_bytes;
                        }

                        if (pwc != NULL)
                        {
                                *pwc = ptstate->wc_value;
                        }

                        INIT_MBSTATE_OBJECT(*ptstate);
                }
                else if (i == n)
                {
                        result = (size_t) -2;
                }
                else
                {
                        errno = EILSEQ;
                        result = (size_t) -1;
                        INIT_MBSTATE_OBJECT(internal_state);
                }
        }

        return result;
}

#endif
