
/**************************************************************************
**                                                                        *
**  FILE        :  malloc-error.c                                         *
**                                                                        *
**  DESCRIPTION :  Default error function for run-time malloc checking.   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include "runtime-error.h"
#include "malloc-error.h"

#pragma runtime -bounds

/*
 * This function is called from runtime-malloc.c to report malloc problems.
 */
extern  void    __malloc_error ( void* address, size_t size, const char* text )
{
        static  char    buf[80];
        const   char*   msg;

        msg = buf;
        if      ( size )
        {
                snprintf( buf, sizeof(buf), "%s (address %p, size %zu)",
                          text, address, size );
        }
        else if ( address )
        {
                snprintf( buf, sizeof(buf), "%s (%p)", text, address );
        }
        else
        {
                msg = text;
        }
        __runtime_error( msg );
}
