
/**************************************************************************
**                                                                        *
**  FILE        :  iswctype.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for iswctype routine.                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Determine whether the wide character wc has the property described by 
 * desc.
 * Return 0 on failure.
 */
int iswctype(wint_t wc, wctype_t desc)
{
        int result;

        switch (desc)
        {
        case _alnum:
                if ((wc >= 48 && wc <= 57)
                 || (wc >= 65 && wc <= 90)
                 || (wc >= 97 && wc <= 122))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _alpha:
                if ((wc >= 65 && wc <= 90)
                 || (wc >= 97 && wc <= 122))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _blank:
                if ((wc == 9 || wc == 32))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _cntrl:
                if ((wc >= 0   && wc <= 31)
                 || (wc >= 127 && wc <= 255))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _digit:
                if ((wc >= 48 && wc <= 57))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _graph:
                if ((wc >= 33 && wc <= 126))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _lower:
                if ((wc >= 97 && wc <= 122))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _print:
                if ((wc >= 32 && wc <= 126))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _punct:
                if ((wc >= 33  && wc <= 47)
                 || (wc >= 58  && wc <= 64)
                 || (wc >= 91  && wc <= 96)
                 || (wc >= 123 && wc <= 126))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _space:
                if ((wc == 32)
                 || (wc >= 9 && wc <= 13))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _upper:
                if ((wc >= 65 && wc <= 90))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        case _xdigit:
                if ((wc >= 48 && wc <= 57)
                 || (wc >= 65 && wc <= 70)
                 || (wc >= 97 && wc <= 102))
                {
                        result = 1;
                }
                else
                {
                        result = 0;
                }
                break;
        default:
                result = 0;
        }

        return result;
}

#endif
