
/**************************************************************************
**                                                                        *
**  FILE        :  isinff.c                                               *
**                                                                        *
**  DESCRIPTION :  The isinff() function.                                 *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

/*****************************************************************************
|*
|* FUNCTION     : isinff
|*
|* PARAMETERS   :
|*
|*      float type variable to test
|*
|* RETURN VALUE :
|*
|*      zero if the variable is not +-infinity, else non-zero
|*
|* DESCRIPTION  :
|*
|*     IEEE-754-1985 Recommended function.
|*     Test the given variable on being an infinite (IEEE-754) value.
|*
*/
#ifdef  __SINGLE_FP__
#pragma alias   _isinf          = _isinf_spf
#pragma alias   _isinfl         = _isinf_spf
#endif
#pragma alias   _isinff         = _isinf_spf
static
int     _isinf_spf( float f )
{
#if _IEEE_754_FORMAT
        float2long_t    u;
        unsigned long   l;

        u.f     = f;
        l       = u.l;

        return GET_FLOAT_EXPONENT( l ) == FLOAT_BIASED_INF_EXP && GET_FLOAT_MANTISSA( l ) == 0;
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
}
