
/**************************************************************************
**                                                                        *
**  FILE        :  isfin.c                                                *
**                                                                        *
**  DESCRIPTION :  The isfinite() function.                               *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

/*****************************************************************************
|*
|* FUNCTION     : isfinite
|*
|* PARAMETERS   :
|*
|*      double type variable to test
|*
|* RETURN VALUE :
|*
|*      zero if the variable is not finite, else non-zero
|*
|* DESCRIPTION  :
|*
|*     IEEE-754-1985 Recommended function.
|*     Test the given variable on being a finite (IEEE-754) value.
|*
*/
#ifndef __SINGLE_FP__
#pragma alias   _isfinite               = _isfinite_dpf
#pragma alias   _isfinitel              = _isfinite_dpf
static
int     _isfinite_dpf( double d )
{
#if _IEEE_754_FORMAT
        double2longs_t  u;
        unsigned long   hi;

        /* double type acts as double */
        u.d     = d;
        hi      = u.s.hi;

        return GET_DOUBLE_EXPONENT( hi ) <= MAX_DOUBLE_BIASED_EXP;
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
}
#endif
