
/**************************************************************************
**                                                                        *
**  FILE        :  get_argcv.c                                            *
**                                                                        *
**  DESCRIPTION :  The __get_argcv.c function reserves space for argv     *
**                 argument and uses the debugger trap to setup argc/     *
**                 argv.                                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <dbg.h>

#ifndef __ARGCV_BUFSIZE
#define __ARGCV_BUFSIZE       256       /* Buffer size for argv */
#endif

union
{
        char data[__ARGCV_BUFSIZE];
        char * pointers;                /* Force to pointer alignment */
} __argcvbuf;

extern int __get_argcv( void )
{
        return _argcv( (void *) &__argcvbuf, sizeof(__argcvbuf) );
}
