
/**************************************************************************
**                                                                        *
**  FILE        :  fwscanf.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for fwscanf() routine.                     *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int fwscanf( FILE * restrict fp, const wchar_t * restrict format, ... )
{
        va_list ap;
        int     items;

        va_start( ap, format );
        items = _dowscan( (struct _io *)&fp, format, ap );
        va_end( ap );
        return (ferror(fp) ? EOF : items);
}

#endif
