
/**************************************************************************
**                                                                        *
**  FILE        :  fwrite.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for fwrite() routine                       *
**                 Writes a number of objects to stdout                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>

size_t  fwrite ( const void * restrict ptr, size_t size, size_t nobj,
                 FILE * restrict fp )
{
        size_t  objs;
        int     i;
        char    *cp;

        cp = (char *) ptr;
        for     ( objs = 0; objs < nobj; objs++ )
        {
                for     ( i = 0; i < size; i++ )
                {
                        putc( *cp, fp );
                        cp++;   /* don't put this in putc() macro */
                }
                if      ( ferror( fp ) )
                {
                        break;
                }
        }
        return objs;
}
