
/**************************************************************************
**                                                                        *
**  FILE        :  fwide.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for fwide routine.                         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <wchar.h>

/*
 * Determine the orientation of the stream pointed to by stream. If the 
 * stream hasn't already been determined, then make the stream wide-oriented
 * if mode > 0 or make the stream byte-oriented if mode < 0.
 *
 * Return a value greater than zero if, after the call, the stream has wide
 * orientation, a value less than zero if the stream has byte orientation,
 * or zero if the stream has no orientation.
 */
#ifdef WCHAR_SUPPORT_ENABLED
int fwide(FILE *stream, int mode)
{
        int result;

        if (mode < 0 && !(stream->_flag & _IOCHAR || stream->_flag & _IOWCHAR))
        {
                stream->_flag |= _IOCHAR;       /* stream is byte-oriented */
                result = -1;
        }
        else if (mode > 0 && !(stream->_flag & _IOCHAR || stream->_flag & _IOWCHAR))
        {
                stream->_flag |= _IOWCHAR;      /* stream is wide-oriented */
                result = +1;
        }
        else
        {
                if (stream->_flag & _IOCHAR)
                {
                        result = -1;            /* stream is byte-oriented */
                }
                else if (stream->_flag & _IOWCHAR)
                {
                        result = +1;            /* stream is wide-oriented */
                }
                else
                {
                        result = 0;             /* stream is no-oriented   */
                }
        }

        return result;
}
#endif
