
/**************************************************************************
**                                                                        *
**  FILE        :  fputwc.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for fputwc routine.                        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <errno.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED    

wint_t fputwc(wchar_t c, FILE *stream)
{
        wint_t result;

        if (c > (wchar_t) UCHAR_MAX)
        {
        /* Encoding error occured.
         */
                errno = EILSEQ;
                result = WEOF;
        }
        else
        {
        /* Write a character to stream.
         */
                if (--stream->_cnt >= 0)
                {
                        *stream->_ptr++ = (char) c;
                        result = (c & 0xff);
                }
                else
                {
                        result = _wflsbuf((unsigned char) c, stream);
                }
        }
        return result;
}

#endif
