
/**************************************************************************
**                                                                        *
**  FILE        :  fputs.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for fputs() routine                        *
**                 Writes a complete string to the given stream           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>

int     fputs( const char * restrict s, FILE * restrict fp )
{
        register int c;

        while ( *s != '\0' )                    /* write until null character */
        {
                c = (unsigned char) *s++;
                if ( fputc( c, fp ) != c )
                {
                        return EOF;             /* error */
                }
        }
        return 0;
}
