
/**************************************************************************
**                                                                        *
**  FILE        :  fopen.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for fopen() routine                        *
**                 Searches for an empty stream and opens it              *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

FILE *fopen(const char * restrict file, const char * restrict mode)
{
        FILE    *fp;
        int     i;

        for (i = 0; i < _NFILE; ++i)
        {
                fp = &_iob[i];
                if (!fp->_flag)
                {
                        if (_fopen(file, mode, fp))
                        {
                                return fp;
                        }
                        break;
                }
        }
        return NULL;
}
