
/**************************************************************************
**                                                                        *
**  FILE        :  fmod.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for fmod() routine                         *
**                 Returns the floating point remainder of the division   *
**                 of x by y, zero if y is zero or if x/y would overflow. *
**                 0 <= | remainder |<| y | and sign remainder is sign x. *
**                                                                        *
** NOTE: This implementation is for IEEE754 doubles, hence -0.0 support.  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <math.h>
#include <float.h>

#ifdef __SINGLE_FP__
#pragma alias   fmodl   = _fmod_spf
#pragma alias   fmod            = _fmod_spf
#endif
#pragma alias   fmodf   = _fmod_spf


static
float
_fmod_spf( float x, float y )
{
        float n;

        if( y == 0.0f )
                return( 0.0f );

        if( (y < 0.0f ? -y : y) < (x < 0.0f ? -x : x) )
                return( y * modff( x / y, &n) );
        else
                if( (y < 0.0f ? -y : y) > (x < 0.0f ? -x : x) )
                        return( x );
                else
                {
                        /* IEEE754: if x is negative, the remainder is negative -> copy the sign */
                        return copysignf( 0.0f, x );
                }
}


