
/**************************************************************************
**                                                                        *
**  FILE        :  fabs.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for fabs() routine                         *
**                 Returns the absolute value of the given 'double'       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>

#ifdef __SINGLE_FP__
#pragma alias   fabsl   = _fabs_spf
#pragma alias   fabs            = _fabs_spf
#endif
#pragma alias   fabsf   = _fabs_spf


static
float
_fabs_spf( float arg )
{
        return copysignf( arg, 1.0f );
}


