

        .extern __aeabi_ldiv0
        .section .text.libc

    .if @BIGENDIAN()
        .define hi1     'r0'
        .define lo1     'r1'
        .define hi2     'r2'
        .define lo2     'r3'
    .else
        .define hi1     'r1'
        .define lo1     'r0'
        .define hi2     'r3'
        .define lo2     'r2'
    .endif
        
        .thumb
        
        .global __aeabi_ldivmod
__aeabi_ldivmod:        .type func
        ; check for division by zero
        cbnz    lo2,unonzero
        cbz     hi2,divide_by_zero
        
unonzero:
        push    {r4,r5,r6,r7,lr}
        
        ands    r4,hi2,#0x80000000
        bpl     pos1
        rsbs    lo2,lo2,#0
        rsb     hi2,hi2,#0
        it      cc              ; if ( borrow )
        subcc   hi2,hi2,#1
pos1:   
        eors    ip,r4,hi1,asr #32
        bcc     pos2
        rsbs    lo1,lo1,#0
        rsb     hi1,hi1,#0
        it      cc              ; if ( borrow )
        subcc   hi1,hi1,#1
pos2:   
                
        ; lr already saved
        bl      common_ldivmod  ; for size considerations

        movs    ip,ip,lsl #1
        bcc     pos3
        rsbs    lo1,lo1,#0
        rsb     hi1,hi1,#0
        it      cc              ; if ( borrow )
        subcc   hi1,hi1,#1
pos3:
        cmp     ip,#0
        bge     pos4
        rsbs    lo2,lo2,#0
        rsb     hi2,hi2,#0
        it      cc              ; if ( borrow )
        subcc   hi2,hi2,#1
pos4:   
                
        pop     {r4,r5,r6,r7,pc}
        
divide_by_zero:
        cmp     hi1,#0
        bgt     posdivzero
        blt     negdivzero
        
        cmp     lo1,#0
        beq     numerator_set
        bgt     posdivzero

negdivzero:
        ldr     hi1,=0x80000000
        ldr     lo1,=0x00000000
        b       numerator_set

posdivzero:
        ldr     hi1,=0x7fffffff
        ldr     lo1,=0xffffffff
        
numerator_set:
        str     lr,[sp,#-4]!
        bl      __aeabi_ldiv0
        ldr     lr, [sp], #4

        bx      lr
        .size   __aeabi_ldivmod,$-__aeabi_ldivmod

        .global __aeabi_uldivmod
__aeabi_uldivmod:       .type func
        ; check for division by zero
        cbnz    lo2,common_ldivmod
        cbnz    hi2,common_ldivmod
        
udivide_by_zero:
        cmp     hi1,#0
        bhi     u_posdivzero
        cbz     lo1,u_numerator_set
u_posdivzero:
        ldr     hi1,=0xffffffff
        mov     lo1,#0

u_numerator_set:
        str     lr,[sp,#-4]!
        bl      __aeabi_ldiv0
        ldr     lr, [sp], #4

        bx      lr
        .size   __aeabi_uldivmod,$-__aeabi_uldivmod

; common code (unsigned division)
common_ldivmod: .type func
        push    {r4,r5,r6,r7}

        movs    r6,lo2
        movs    r7,hi2

        movs    r4,lo1,lsr #1
        orrs    r4,r4,hi1,lsl #31
        movs    r5,hi1,lsr #1
u_just_l:
        cmp     r7,r5
        it      eq
        cmpeq   r6,r4
        ittt    ls
        movls   r7,r7,lsl #1
        orrls   r7,r7,r6,lsr #31
        movls   r6,r6,lsl #1
        it      lo
        blo     u_just_l

        movs    r4,#0
        movs    r5,#0
u_div_l:        
        cmp     hi1,r7
        it      eq
        cmpeq   lo1,r6
        bcs     carry_set
        adds    r4,r4,r4
        adcs    r5,r5,r5
        b       l_1
carry_set:
        adcs    r4,r4,r4
        adcs    r5,r5,r5
        subs    lo1,lo1,r6
        sbcs    hi1,hi1,r7
l_1:
        teq     r7,hi2
        it      eq
        teqeq   r6,lo2
        ittt    ne
        movne   r6,r6,lsr #1
        orrne   r6,r6,r7,lsl #31
        movne   r7,r7,lsr #1

        bne     u_div_l
                
        movs    lo2,lo1
        movs    hi2,hi1
        movs    lo1,r4
        movs    hi1,r5
        
        pop     {r4,r5,r6,r7}
        bx      lr
        .size   common_ldivmod,$-common_ldivmod

        .endsec

        .calls  '__aeabi_ldivmod','__aeabi_ldiv0'
        .calls  '__aeabi_ldivmod','',20
        .calls  '__aeabi_uldivmod','__aeabi_ldiv0'
        .calls  '__aeabi_uldivmod','',16

        .end
